﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using AntiXssEnc = Microsoft.Security.Application;
using VIRP_WEB.SoaServices;
using System.Linq;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.AHOBPR.BO;

namespace VIRP_WEB.BaseCode
{
    public static class Helpers
    {
        public static Boolean IsInteger(string valueToCheck)
        {
            long tempInt;

            try
            {
                tempInt = Convert.ToInt64(valueToCheck);
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static Boolean IsString(string valueToCheck)
        {
            string tempString;

            try
            {
                tempString = valueToCheck.ToString();
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// useful function to convert to various nullable types from string
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="input"></param>
        /// <returns></returns>
        public static T? ConvertStringToNullable<T>(string input) where T : struct
        {
            T? result = null;

            TypeConverter converter = TypeDescriptor.GetConverter(typeof(T));

            if (string.IsNullOrEmpty(input))
            {
                result = null;
            }
            else
            {
                try
                {
                    result = (T)converter.ConvertFromString(input);
                }
                catch
                {
                    result = null;
                }
            }

            return result;
        }

        public static Nullable<T> ToNullable<T>(this string s) where T : struct
        {
            Nullable<T> result = new Nullable<T>();
            try
            {
                if (!string.IsNullOrEmpty(s) && s.Trim().Length > 0)
                {
                    TypeConverter conv = TypeDescriptor.GetConverter(typeof(T));
                    result = (T)conv.ConvertFrom(s);
                }
            }
            catch
            {
            }
            return result;
        }

        public static string SessionItemValueGet(object sessionObject)
        {
            string result = null;

            var item = sessionObject as SessionItem;
            if (item != null)
                result = item.Value;

            return result;
        }

        /// <summary>
        /// Get the last printed contact log record
        /// </summary>
        /// <param name="referralId"></param>
        /// <returns></returns>
        public static ContactLog GetLastPrintedContactLog(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int referralId)
        {
            ContactLog contactLog = null;

            List<ContactLog> contacts = CONTACT_LOGManager.SelectByID(CURRENT_USER, CURRENT_REGISTRY_ID, referralId);
            foreach (ContactLog contact in contacts)
            {
                if (contact.ContactReason == EFRSharedConstant.ContactLogReasonPrinted)
                {
                    contactLog = contact;
                    break;
                }
            }

            return contactLog;
        }

        public static string AntiXssEval(Object o)
        {
            if (o == null)
            {
                return string.Empty;
            }
            return AntiXssEnc.Encoder.HtmlEncode(o.ToString(), false);
        }
        
        public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
        {
            return string.IsNullOrEmpty(GetStringFromSessionVariable(sessionVariable));
        }

        public static int GetIntFromString(string inString)
        {
            int returnInt = 0;

            int tempInt;
            bool result = int.TryParse(inString, out tempInt);
            if (result)
            {
                returnInt = tempInt;
            }

            return returnInt;
        }

        public static string GetStringFromSessionVariable(object sessionVariable)
        {
            string result = string.Empty;

            if (sessionVariable != null)
            {
                result = sessionVariable.ToString();
            }

            return result;
        }

        public static string FullName(VIRP_WEB.SoaServices.PATIENT patient)
        {
            if (patient != null)
                return patient.LAST_NAME + ", " + patient.FIRST_NAME + " " + patient.MIDDLE_NAME;
            else
                return string.Empty;
        }

        public static string FullName(VIRP.CRS.BO.PATIENT patient)
        {
            if (patient != null)
                return patient.LAST_NAME + ", " + patient.FIRST_NAME + " " + patient.MIDDLE_NAME;
            else
                return string.Empty;
        }

        public static string GetGender(string CURRENT_USER, int CURRENT_REGISTRY_ID, int genderId)
        {
            string genderName = string.Empty;

            STD_GENDER gender = ServiceInterfaceManager.STD_GENDER_GET(CURRENT_USER, CURRENT_REGISTRY_ID, genderId);
            if (gender != null)
                genderName = gender.NAME;

            return genderName;
        }

        public static bool IsDestinationUrlLocal(string pDestinationUrl, string currentHost)
        {
            bool isValidUrl = false;
            string localHost = string.Concat("https://", currentHost, "/");
            string newUrl = string.Concat(localHost, pDestinationUrl);
            Uri destinationUrl;
            Uri.TryCreate(newUrl, UriKind.Absolute, out destinationUrl);
            if (destinationUrl != null && currentHost == destinationUrl.Host)
            {
                isValidUrl = true;
            }
            return isValidUrl;
        }

        public static IEnumerable<T> SortBy<T>(this IEnumerable<T> objReturn, string SORT_EXPRESSION)
        {
            //IOrderedEnumerable<T> objOrderedReturn = null;
            if (!string.IsNullOrEmpty(SORT_EXPRESSION))
            {
                if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                {
                    SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);
                    if (SORT_EXPRESSION.Contains("."))
                    {
                        string[] props = SORT_EXPRESSION.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)));
                        }
                        else if (props != null && props.Count() == 3)
                        {
                        }
                    }
                    else
                    {
                        objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s));
                    }
                }
                else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                {
                    SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                    if (SORT_EXPRESSION.Contains("."))
                    {
                        string[] props = SORT_EXPRESSION.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)));
                        }
                        else if (props != null && props.Count() == 3)
                        {
                        }
                    }
                    else
                    {
                        objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s));
                    }
                }
                else
                {
                    if (SORT_EXPRESSION.Contains("."))
                    {
                        string[] props = SORT_EXPRESSION.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)));
                        }
                        else if (props != null && props.Count() == 3)
                        {
                        }
                    }
                    else
                    {
                        objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s));
                    }
                }
            }

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetInsitutionList(string userId, int registryId)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            List<VIRP.CRS.BO.STD_INSTITUTION> lsi = VIRP.CRS.BLL.STD_INSTITUTIONManager.GetFacilitiesShorterName(userId, registryId);

            foreach (VIRP.CRS.BO.STD_INSTITUTION si in lsi)
            {
                objReturn.Add(new KeyValuePair<int, string>(si.ID, si.NAME));
            }

            return objReturn;
        }

        public static DateTime GetDateFromString(string inString)
        {
            DateTime returnDate = DateTime.MinValue;
            DateTime tempDate;
            bool result = DateTime.TryParse(inString, out tempDate);
            if (result)
            {
                returnDate = tempDate;
            }
            return returnDate;
        }

        public static string getShortDateStringFromNullableDate(DateTime? inDate)
        {
            string returnString = "";
            if (inDate.HasValue)
            {
                returnString = Convert.ToDateTime(inDate).ToShortDateString();
            }
            return returnString;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static List<KeyValuePair<string, string>> ConvertToKeyValuePair(string value)
        {
            List<KeyValuePair<string, string>> result = new List<KeyValuePair<string, string>>();

            if (!string.IsNullOrEmpty(value))
            {
                List<string> valueList = value.Split(',').ToList();
                foreach (string item in valueList)
                {
                    if (!string.IsNullOrEmpty(item))
                    {
                        KeyValuePair<string, string> pair = new KeyValuePair<string, string>(item, string.Empty);
                        result.Add(pair);
                    }
                }
            }

            return result;
        }

        public static int getIntFromString(string inString)
        {
            int returnInt = 0;
            int tempInt;
            bool result = int.TryParse(inString, out tempInt);
            if (result)
            {
                returnInt = tempInt;
            }
            return returnInt;
        }
		
        public static void AddActivityToAuditLog(int userId, string currentUser, int currentRegistryId, string message, string registrantId, VIRP.AHOBPR.BO.AuditLogType type, int? numberOfRegistrants)
        {
            SoaServices.AUDIT_LOG auditLog = new SoaServices.AUDIT_LOG();
            auditLog.CREATED = auditLog.UPDATED = DateTime.Now;
            auditLog.CREATEDBY = auditLog.UPDATEDBY = currentUser;
            auditLog.MESSAGE = message;
            auditLog.REGISTRANT_ID = String.IsNullOrEmpty(registrantId) ? null : (int?)int.Parse(registrantId);
            auditLog.TYPE_ID = (byte)(int)type;
            auditLog.USER_ID = userId;
            auditLog.NUMBER_OF_REGISTRANTS = numberOfRegistrants;

            ServiceInterfaceManager.AUDIT_LOG_Save(currentUser, currentRegistryId, auditLog);
        }
    }
}